package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderStatus;
import ru.yandex.misc.enums.StringEnum;

public enum OrderStatusApi implements StringEnum {
    INIT("init", OrderStatus.INIT),
    PAID("paid", OrderStatus.PAID),
    UPGRADED("upgraded", OrderStatus.UPGRADED),
    ON_HOLD("on_hold", OrderStatus.ON_HOLD),
    PAYMENT_ERROR("payment_error", OrderStatus.ERROR);

    private static final MapF<OrderStatus, OrderStatusApi> coreToWeb = Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(OrderStatusApi.values()).toMap(v -> v.orderStatus, Function.identityF()));
    }


    private final String value;
    private final OrderStatus orderStatus;

    OrderStatusApi(String value, OrderStatus orderStatus) {
        this.value = value;
        this.orderStatus = orderStatus;
    }

    public OrderStatus toCoreEnum() {
        return orderStatus;
    }

    public static OrderStatusApi fromCoreEnum(OrderStatus type) {
        return coreToWeb.getOrThrow(type);
    }


    @Override
    public String value() {
        return value;
    }
}
