package ru.yandex.chemodan.app.psbilling.web.model;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderType;
import ru.yandex.misc.enums.StringEnum;

@AllArgsConstructor
public enum OrderTypeApi implements StringEnum {
    PROMO_CODE("promocode_order", OrderType.PROMOCODE_ORDER),
    //не светим во фронты лишние статусы. только явно запрошенная по дизайну инфа
    UNSPECIFIED("unspecified", OrderType.ORDER, OrderType.SUBSCRIPTION, OrderType.INAPP_SUBSCRIPTION);

    private final String value;
    private final ListF<OrderType> correspondingTypes;

    OrderTypeApi(String value, OrderType... correspondingTypes) {
        this.value = value;
        this.correspondingTypes = Cf.list(correspondingTypes);
    }

    public static OrderTypeApi fromCoreEnum(OrderType orderType) {
        for(OrderTypeApi ota: values()) {
            if(ota.correspondingTypes.containsTs(orderType)){
                return ota;
            }
        }
        throw new RuntimeException("Can not determine order type API for order type " + orderType);
    }

    @Override
    public String value() {
        return value;
    }
}
