package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import ru.yandex.chemodan.app.psbilling.core.balance.PaymentData;
import ru.yandex.chemodan.app.psbilling.core.balance.PhPaymentData;
import ru.yandex.chemodan.app.psbilling.core.balance.UrPaymentData;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@Setter
@NoArgsConstructor
public abstract class PaymentDataPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("type")
    protected String type;
    @JsonProperty("email")
    protected String email;
    @JsonProperty("phone")
    protected String phone;
    @JsonProperty("country_code")
    protected String countryCode;
    @JsonProperty("has_contract")
    protected boolean hasContract;

    public PaymentDataPojo(String type) {
        this.type = type;
    }

    public abstract PaymentData toCorePaymentData();

    public abstract String getName();

    public static PaymentDataPojo of(PaymentData paymentData,  boolean hasContract) {
        if (paymentData instanceof UrPaymentData) {
            return new UrPaymentDataPojo((UrPaymentData) paymentData, hasContract);
        } else if (paymentData instanceof PhPaymentData) {
            return new PhPaymentDataPojo((PhPaymentData) paymentData, hasContract);
        }

        throw new IllegalArgumentException("Unknown payment data type");
    }
}
