package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.chemodan.app.psbilling.core.billing.users.TrustFormTemplate;
import ru.yandex.misc.enums.StringEnum;

public enum PaymentFormTypeApi implements StringEnum {
    MOBILE("mobile", TrustFormTemplate.MOBILE),
    DESKTOP("desktop", TrustFormTemplate.DESKTOP);

    private String value;
    private TrustFormTemplate trustFormTemplate;

    PaymentFormTypeApi(String value, TrustFormTemplate trustFormTemplate) {
        this.value = value;
        this.trustFormTemplate = trustFormTemplate;
    }

    public TrustFormTemplate getTrustFormTemplate() {
        return trustFormTemplate;
    }

    @Override
    public String value() {
        return value;
    }
}
