package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceBillingStatus;
import ru.yandex.misc.enums.StringEnum;

public enum PaymentStatusApi implements StringEnum {
    PAID("paid", UserServiceBillingStatus.PAID),
    FREE_PERIOD("free_period", UserServiceBillingStatus.FREE_PERIOD),
    WAIT_AUTO_PROLONG("wait_auto_prolong", UserServiceBillingStatus.WAIT_AUTO_PROLONG);

    private static final MapF<UserServiceBillingStatus, PaymentStatusApi> coreToWeb = Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(PaymentStatusApi.values()).toMap(v -> v.coreEnum, Function.identityF()));
    }

    private String value;
    private UserServiceBillingStatus coreEnum;

    PaymentStatusApi(String value, UserServiceBillingStatus coreEnum) {
        this.value = value;
        this.coreEnum = coreEnum;
    }

    @Override
    public String value() {
        return value;
    }

    public UserServiceBillingStatus toCoreEnum() {
        return coreEnum;
    }

    public static PaymentStatusApi fromCoreEnum(UserServiceBillingStatus type) {
        return coreToWeb.getOrThrow(type);
    }

}
