package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.chemodan.app.psbilling.core.balance.PaymentData;
import ru.yandex.chemodan.app.psbilling.core.balance.PhPaymentData;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;

/**
 * @author friendlyevil
 */
@AllArgsConstructor
@Getter
@Setter
public class PhPaymentDataPojo extends PaymentDataPojo {
    @JsonProperty("last_name")
    private String lastName;
    @JsonProperty("first_name")
    private String firstName;
    @JsonProperty("middle_name")
    private String middleName;

    public PhPaymentDataPojo() {
        super(GetClientPersonsResponseItem.NATURAL_PERSON_TYPE);
    }

    public PhPaymentDataPojo(String email, String phone, String countryCode, String lastName, String firstName,
                             String middleName, boolean hasContract) {
        super(GetClientPersonsResponseItem.NATURAL_PERSON_TYPE, email, phone, countryCode, hasContract);
        this.lastName = lastName;
        this.firstName = firstName;
        this.middleName = middleName;
    }

    public PhPaymentDataPojo(PhPaymentData data, boolean hasContract) {
        this(data.getEmail(), data.getPhone(), data.getCountryCode(), data.getLastName(), data.getFirstName(),
                data.getMiddleName(), hasContract);
    }

    @Override
    public PaymentData toCorePaymentData() {
        return new PhPaymentData(email, phone, countryCode, lastName, firstName, middleName);
    }

    @Override
    public String getName() {
        return firstName + " " + lastName;
    }
}
