package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.PriceOverrideReason;
import ru.yandex.misc.enums.StringEnum;

public enum PriceOverrideReasonApi implements StringEnum {
    TRIAL("trial", PriceOverrideReason.TRIAL),
    GIFT("gift", PriceOverrideReason.GIFT);

    private String value;
    private PriceOverrideReason coreEnum;

    private static final MapF<PriceOverrideReason, PriceOverrideReasonApi> coreToWeb = Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(PriceOverrideReasonApi.values()).toMap(v -> v.coreEnum, Function.identityF()));
    }

    PriceOverrideReasonApi(String value, PriceOverrideReason coreEnum) {
        this.value = value;
        this.coreEnum = coreEnum;
    }

    @Override
    public String value() {
        return value;
    }

    public static PriceOverrideReasonApi fromCoreEnum(PriceOverrideReason type) {
        return coreToWeb.getOrThrow(type);
    }

}
