package ru.yandex.chemodan.app.psbilling.web.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupServicePriceOverride;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@NoArgsConstructor

public class PriceOverridesPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("start_date")
    private Instant startDate;
    @JsonProperty("end_date")
    private Option<Instant> endDate;
    @JsonProperty("price_per_user_in_month")
    private BigDecimal pricePerUserInMonth;

    @JsonProperty("reason")
    private PriceOverrideReasonApi reason;

    public PriceOverridesPojo(GroupServicePriceOverride groupServicePriceOverride) {
        this.startDate = groupServicePriceOverride.getStartDate();
        this.endDate = groupServicePriceOverride.getEndDate();
        this.pricePerUserInMonth = groupServicePriceOverride.getPricePerUserInMonth();
        this.reason = PriceOverrideReasonApi.fromCoreEnum(groupServicePriceOverride.getReason());
    }
}
