package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class ProductSetPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("items")
    private List<ProductWithPricesPojo> items = Cf.list();
    @JsonProperty("available_until_date")
    private Option<Instant> availableUntil = Option.empty();
    @JsonProperty("current_subscription")
    @Deprecated
    private Option<UserServicePojo> currentSubscription = Option.empty();
    @JsonProperty("order_status")
    @Deprecated
    private Option<OrderStatusApi> orderStatus = Option.empty();
    @JsonProperty("active_promo")
    private Option<PromoPojo> activePromo = Option.empty();
}
