package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.products.UserProduct;

@Getter
@NoArgsConstructor
public class ProductWithPricesPojo extends AbstractUserProductPojo {
    @JsonProperty("prices")
    private List<ProductPricePojo> prices;

    public ProductWithPricesPojo(UserProduct product, String title, List<FeaturePojo> features,
            List<ProductPricePojo> prices)
    {
        super(product, title, features);
        this.prices = prices;
    }
}
