package ru.yandex.chemodan.app.psbilling.web.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.promocodes.model.PromoCodeFailCodeEnum;
import ru.yandex.misc.enums.StringEnum;

@RequiredArgsConstructor
public enum PromoCodeFailCodeApi implements StringEnum {
    ALREADY_USED("promo_code_already_used", PromoCodeFailCodeEnum.ALREADY_USED),
    EXCEPT_EDU("except_edu_promo_check_rule_error", PromoCodeFailCodeEnum.EXCEPT_EDU),
    EXPENSIVE_CURRENT_PRODUCT("expensive_current_product_promo_check_rule_error",
            PromoCodeFailCodeEnum.EXPENSIVE_CURRENT_PRODUCT),
    ONLY_EDU("only_edu_promo_check_rule_error", PromoCodeFailCodeEnum.ONLY_EDU),
    UNAVAILABLE("unavailable_promo_check_rule_error", PromoCodeFailCodeEnum.UNAVAILABLE),
    ONLY_POSTPAID("only_postpaid_promo_check_rule_error", PromoCodeFailCodeEnum.ONLY_POSTPAID),
    ONLY_PREPAID("only_prepaid_promo_check_rule_error", PromoCodeFailCodeEnum.ONLY_PREPAID);
    private final String value;
    private final PromoCodeFailCodeEnum promoCodeFailCodeEnum;


    public static PromoCodeFailCodeApi fromCoreEnum(PromoCodeFailCodeEnum promoCodeFailCodeEnum) {
        for (PromoCodeFailCodeApi ota : values()) {
            if (ota.promoCodeFailCodeEnum == promoCodeFailCodeEnum) {
                return ota;
            }
        }
        throw new RuntimeException("Can not determine promo code fail code API for promo code fail code " + promoCodeFailCodeEnum);
    }

    @Override
    public String value() {
        return value;
    }
}
