package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeType;
import ru.yandex.misc.enums.StringEnum;

public enum PromoCodeTypeApi implements StringEnum {
    B2C("b2c", PromoCodeType.B2C),
    B2B("b2b", PromoCodeType.B2B);

    private static final MapF<PromoCodeType, PromoCodeTypeApi> coreToWeb = Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(PromoCodeTypeApi.values()).toMap(v -> v.promoCodeType, Function.identityF()));
    }
    private final String value;
    private final PromoCodeType promoCodeType;

    PromoCodeTypeApi(String value, PromoCodeType promoCodeType) {
        this.value = value;
        this.promoCodeType = promoCodeType;
    }

    public PromoCodeType toCoreEnum() {
        return promoCodeType;
    }

    public static PromoCodeTypeApi fromCoreEnum(PromoCodeType type) {
        return coreToWeb.getOrThrow(type);
    }


    @Override
    public String value() {
        return value;
    }
}
