package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.StringUtils;

public enum ServiceStatus implements StringEnum {
    ACTIVE(Target.ENABLED),
    DISABLED(Target.DISABLED);


    private final Target coreEnum;
    private static final MapF<Target, ServiceStatus>
            coreToWeb = Cf.hashMap();

    static {
        coreToWeb.putAll(Cf.x(ServiceStatus.values()).toMap(v -> v.coreEnum, Function.identityF()));
    }

    public static final StringEnumResolver<ServiceStatus> R = StringEnumResolver.r(ServiceStatus.class);


    ServiceStatus(Target coreEnum) {
        this.coreEnum = coreEnum;
    }

    @Override
    public String value() {
        return name();
    }

    public Target toCoreEnum() {
        return coreEnum;
    }

    public static ServiceStatus fromCoreEnum(Target type) {
        return coreToWeb.getOrThrow(type);
    }

    public static ServiceStatus[] parseStatuses(
            Option<String> statusesO)
    {
        if (!statusesO.isPresent()) {
            return new ServiceStatus[]{ACTIVE};
        }

        String statusesStr = statusesO.get();
        if (StringUtils.isBlank(statusesStr)) {
            return ServiceStatus.values();
        }

        return Cf.x(StringUtils.split(statusesStr, ","))
                .map(String::trim)
                .map(String::toLowerCase)
                .map(Target.R::fromValue)
                .map(ServiceStatus::fromCoreEnum)
                .toArray(ServiceStatus.class);
    }

    public static Target[] statusesToTarget(Option<String> statusesO) {
        return Cf.list(parseStatuses(statusesO)).map(ServiceStatus::toCoreEnum).toArray(Target.class);
    }


}
