package ru.yandex.chemodan.app.psbilling.web.model;

import java.util.Arrays;
import java.util.NoSuchElementException;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.StringUtils;

public enum ServiceStatusFilter implements StringEnum {
    ENABLED("enabled", Target.ENABLED, Option.empty()),
    DISABLED("disabled", Target.DISABLED, Option.empty()),
    ON_HOLD("on_hold", Target.DISABLED, Option.of(OrderStatus.ON_HOLD));


    private final Target serviceTarget;
    private final Option<OrderStatus> orderStatusFilter;
    private final String value;


    ServiceStatusFilter(String value, Target serviceTarget, Option<OrderStatus> orderStatus) {
        this.value = value;
        this.serviceTarget = serviceTarget;
        this.orderStatusFilter = orderStatus;
    }

    @Override
    public String value() {
        return value;
    }

    public static ServiceStatusFilter fromValue(String value) {
        return Arrays.stream(ServiceStatusFilter.values())
                .filter(filter -> filter.value().equalsIgnoreCase(value))
                .findAny()
                .orElseThrow(NoSuchElementException::new);
    }

    public Target getServiceTarget() {
        return serviceTarget;
    }
    public Option<OrderStatus> getOrderStatusFilter() {
        return orderStatusFilter;
    }


    public static ServiceStatusFilter[] parseFilters(
            Option<String> statusesO, ServiceStatusFilter defaultFilter) {
        if (!statusesO.isPresent()) {
            return new ServiceStatusFilter[]{defaultFilter};
        }

        String statusesStr = statusesO.get();
        if (StringUtils.isBlank(statusesStr)) {
            return ServiceStatusFilter.values();
        }

        return Cf.x(StringUtils.split(statusesStr, ","))
                .map(String::trim)
                .map(String::toLowerCase)
                .map(ServiceStatusFilter::fromValue)
                .toArray(ServiceStatusFilter.class);
    }
}
