package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.Validate;

public enum SynchronizationStatusApi implements StringEnum {
    ACTUAL("actual", SynchronizationStatus.ACTUAL),
    SYNCHRONIZING("synchronizing", SynchronizationStatus.INIT, SynchronizationStatus.SYNCING,
            SynchronizationStatus.SNOOZING);

    private final String value;
    private final SetF<SynchronizationStatus> coreEnums;

    private static final MapF<SynchronizationStatus, SynchronizationStatusApi> coreToWeb = Cf.hashMap();

    static {
        MapF<SynchronizationStatus, ListF<SynchronizationStatusApi>> mappings = Cf.x(SynchronizationStatusApi.values())
                .map(w -> w.coreEnums.map(c -> Tuple2.tuple(c, w)))
                .flatMap(Function.identityF())
                .groupBy(Tuple2::get1)
                .mapValues(l -> l.map(Tuple2::get2));
        mappings.values().forEach(l -> Validate.sizeIs(1, l));

        coreToWeb.putAll(mappings.mapValues(ListF::first));
    }

    SynchronizationStatusApi(String value, SynchronizationStatus... coreEnums) {
        this.value = value;
        this.coreEnums = Cf.set(coreEnums);
    }

    @Override
    public String value() {
        return value;
    }


    public static SynchronizationStatusApi fromCoreEnum(SynchronizationStatus type)
    {
        return coreToWeb.getOrThrow(type);
    }


}
