package ru.yandex.chemodan.app.psbilling.web.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialDefinitionEntity;
import ru.yandex.chemodan.app.psbilling.core.products.TrialDefinition;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@NoArgsConstructor
public class TrialDefinitionPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("period")
    private Option<CustomPeriodApi> period;
    @JsonProperty("periods_count")
    private Option<Integer> periodsCount;
    @JsonProperty("until_date")
    private Option<Instant> untilDate;
    @JsonProperty("price_per_user_in_month")
    private BigDecimal pricePerUserInMonth;

    public TrialDefinitionPojo(TrialDefinitionEntity d) {
        this.period = d.getDuration().map(CustomPeriod::getUnit).map(CustomPeriodApi::fromCoreEnum);
        this.periodsCount = d.getDuration().map(CustomPeriod::getValue);
        this.untilDate = d.getEndDate();
        this.pricePerUserInMonth = d.getPrice();
    }

    public TrialDefinitionPojo(TrialDefinition d) {
        this.period = d.getDuration().map(CustomPeriod::getUnit).map(CustomPeriodApi::fromCoreEnum);
        this.periodsCount = d.getDuration().map(CustomPeriod::getValue);
        this.untilDate = d.getEndDate();
        this.pricePerUserInMonth = d.getPrice();
    }
}
