package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupProductEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialDefinitionEntity;
import ru.yandex.chemodan.app.psbilling.core.products.TrialDefinition;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@NoArgsConstructor
public class TrialPojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("definition")
    private TrialDefinitionPojo trialDefinition;

    /**
     * может быть четыре случая:
     * 1. триал еще на активировался. тогда он доступен
     * 2. триал уже активировался на нашу текущую организацию, и срок его действия с момента окончания еще не истек.
     * в этом случае он считается доступным.
     * 3. триал уже активировался текущим пользователем, но на другую организацию.
     * или же активировался на текщую организацию, и срок действия его истек. тогда он считается недоступным
     * <p/>
     * 4. Многоразовый триал уже был использовано, и его можно переиспользовать.
     * Логкиа провеки реализована в {@link ru.yandex.chemodan.app.psbilling.core.groups.TrialService#isTrialAvailable(GroupProductEntity, TrialDefinitionEntity, Group, PassportUid)}
     */
    @JsonProperty("available")
    private Option<Boolean> available;
    /**
     * поле актуально только если триал доступен.
     * заполняется в случае, если триал уже активировали
     * показывает момент, по который действует активация
     */
    @JsonProperty("activated_until")
    private Option<Instant> activatedUntil;

    public TrialPojo(TrialDefinition d, boolean available, Option<Instant> activatedUntil) {
        this.trialDefinition = new TrialDefinitionPojo(d);
        this.available = Option.of(available);
        this.activatedUntil = activatedUntil;
    }

    public TrialPojo(TrialDefinition d) {
        this.trialDefinition = new TrialDefinitionPojo(d);
        this.available = Option.empty();
        this.activatedUntil = Option.empty();
    }
}
