package ru.yandex.chemodan.app.psbilling.web.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.chemodan.app.psbilling.core.balance.Address;
import ru.yandex.chemodan.app.psbilling.core.balance.PaymentData;
import ru.yandex.chemodan.app.psbilling.core.balance.UrPaymentData;
import ru.yandex.chemodan.balanceclient.model.response.GetClientPersonsResponseItem;

@AllArgsConstructor
@Getter
@Setter
public class UrPaymentDataPojo extends PaymentDataPojo {
    @JsonProperty("organization_name")
    private String organizationName;
    //10 цифр для юр. лиц, 12 цифр для ИП
    @JsonProperty("inn")
    private String inn;
    //не обязателен для ИП
    @JsonProperty("kpp")
    private String kpp;

    @JsonProperty("legal_address")
    private AddressPojo legalAddress;
    @JsonProperty("post_address")
    private AddressPojo postAddress;

    public UrPaymentDataPojo() {
        super(GetClientPersonsResponseItem.LEGAL_PERSON_TYPE);
    }

    public UrPaymentDataPojo(String email, String phone, String countryCode, String organizationName, String inn,
                             String kpp, AddressPojo legalAddress, AddressPojo postAddress, boolean hasContract) {
        super(GetClientPersonsResponseItem.LEGAL_PERSON_TYPE, email, phone, countryCode, hasContract);
        this.organizationName = organizationName;
        this.inn = inn;
        this.kpp = kpp;
        this.legalAddress = legalAddress;
        this.postAddress = postAddress;
    }

    public UrPaymentDataPojo(UrPaymentData data, boolean hasContract) {
        this(data.getEmail(), data.getPhone(), data.getCountryCode(), data.getOrganizationName(), data.getInn(),
                data.getKpp(), new AddressPojo(data.getLegalAddress()), new AddressPojo(data.getPostAddress()), hasContract);
    }

    @Override
    public PaymentData toCorePaymentData() {
        Address legalAddr =
                legalAddress == null ? null : new Address(legalAddress.getPostcode(), legalAddress.getAddress());
        Address postAddr =
                postAddress == null ? null : new Address(postAddress.getPostcode(), postAddress.getAddress());
        return new UrPaymentData(email, phone, countryCode, organizationName, inn, kpp, legalAddr, postAddr);
    }

    @Override
    public String getName() {
        return organizationName;
    }
}
