package ru.yandex.chemodan.app.psbilling.web.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.products.BillingType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.Validate;

public enum UserProductTypeApi implements StringEnum {
    GROUP("group", BillingType.GROUP),
    SUBSCRIPTION("subscription", BillingType.TRUST, BillingType.FREE),
    INAPP_GOOGLE("inapp_google", BillingType.INAPP_GOOGLE),
    INAPP_APPLE("inapp_apple", BillingType.INAPP_APPLE);

    private String value;
    private SetF<BillingType> coreEnums;

    private static final MapF<BillingType, UserProductTypeApi> coreToWeb = Cf.hashMap();

    static {
        MapF<BillingType, ListF<UserProductTypeApi>> mappings = Cf.x(UserProductTypeApi.values())
                .map(w -> w.coreEnums.map(c -> Tuple2.tuple(c, w)))
                .flatMap(Function.identityF())
                .groupBy(Tuple2::get1)
                .mapValues(l -> l.map(Tuple2::get2));
        mappings.values().forEach(l -> Validate.sizeIs(1, l));

        coreToWeb.putAll(mappings.mapValues(ListF::first));
    }


    UserProductTypeApi(String value, BillingType... coreEnums) {
        this.value = value;
        this.coreEnums = Cf.set(coreEnums);
    }

    @Override
    public String value() {
        return value;
    }


    public static UserProductTypeApi fromCoreEnum(BillingType type)
    {
        return coreToWeb.getOrThrow(type);
    }

}
