package ru.yandex.chemodan.app.psbilling.web.model;


import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.BillingType;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class UserServicePojo extends DefaultObject implements JacksonPojo {
    @JsonProperty("service_id")
    private String serviceId;
    @JsonProperty("readonly")
    private boolean readonly;
    @JsonProperty("creation_date")
    private Instant creationDate;
    @JsonProperty("subscription_until")
    private Option<Instant> subscriptionUntil;
    @JsonProperty("next_payment")
    private Option<PaymentPojo> nextPayment;
    @JsonProperty("status")
    private ServiceStatus status;
    @JsonProperty("synchronization_status")
    private SynchronizationStatusApi synchronizationStatus;
    @JsonProperty("billing_status")
    private Option<PaymentStatusApi> billingStatus;
    @JsonProperty("auto_prolong_enabled")
    private Option<Boolean> autoProlongEnabled;
    @JsonProperty("order_status")
    private OrderStatusApi orderStatus;
    @JsonProperty("order_type")
    private OrderTypeApi orderType;

    @JsonProperty("product")
    private BoughtProductPojo product;

    //for single service
    public UserServicePojo(UserService service, OrderStatusApi orderStatus, BoughtProductPojo mappedProduct, Option<PaymentPojo> nextPayment) {
        this.serviceId = service.getId().toString();
        this.readonly = service.getUserProduct().getBillingType() != BillingType.TRUST;
        this.creationDate = service.getCreatedAt();
        this.subscriptionUntil = service.getSubscriptionUntil();
        this.status = ServiceStatus.fromCoreEnum(service.getTarget());
        this.orderStatus = orderStatus;
        this.billingStatus = service.getBillingStatus().map(PaymentStatusApi::fromCoreEnum);
        this.autoProlongEnabled = service.getAutoProlongEnabledO();
        this.product = mappedProduct;
        this.synchronizationStatus = SynchronizationStatusApi.fromCoreEnum(service.getStatus());
        this.nextPayment = nextPayment;
        this.orderType = service.getLastPaymentOrderType().map(OrderTypeApi::fromCoreEnum).orElse(OrderTypeApi.UNSPECIFIED);
    }

    //for bulk creation. no extra query for order type
    public UserServicePojo(UserService service, OrderStatusApi orderStatus, OrderTypeApi orderType, BoughtProductPojo mappedProduct, Option<PaymentPojo> nextPayment) {
        this.serviceId = service.getId().toString();
        this.readonly = service.getUserProduct().getBillingType() != BillingType.TRUST;
        this.creationDate = service.getCreatedAt();
        this.subscriptionUntil = service.getSubscriptionUntil();
        this.status = ServiceStatus.fromCoreEnum(service.getTarget());
        this.orderStatus = orderStatus;
        this.billingStatus = service.getBillingStatus().map(PaymentStatusApi::fromCoreEnum);
        this.autoProlongEnabled = service.getAutoProlongEnabledO();
        this.product = mappedProduct;
        this.synchronizationStatus = SynchronizationStatusApi.fromCoreEnum(service.getStatus());
        this.nextPayment = nextPayment;
        this.orderType = orderType;
    }

    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    @ToString
    public static class PaymentPojo {
        @JsonProperty("amount")
        private BigDecimal amount;
        @JsonProperty("currency")
        private String currency;

    }
}
