package ru.yandex.chemodan.app.psbilling.web.ratelimiter;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.ratelimiter.yarl.YarlHttpClient;
import ru.yandex.chemodan.ratelimiter.yarl.YarlWithClientFilterInterceptor;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
public class PsBillingRateLimiterInterceptor extends YarlWithClientFilterInterceptor {
    public PsBillingRateLimiterInterceptor(YarlHttpClient yarlHttpClient,
                                           Supplier<Boolean> isDryRun,
                                           Supplier<Boolean> isEnabled,
                                           Supplier<Boolean> isWhiteListMode,
                                           Supplier<ListF<String>> enabledForClients,
                                           Supplier<ListF<String>> disabledForClients) {
        super(yarlHttpClient, isDryRun, isEnabled, isWhiteListMode, enabledForClients, disabledForClients);
    }

    @Override
    protected String clientPrefix() {
        return "ps_billing_";
    }

    @Override
    protected Option<String> getClientId(HttpServletRequestX request) {
        return Option.ofNullable(request.getAttribute(Tvm2Filter.TVM_CLIENT_ID_ATTR))
                .map(String::valueOf);
    }
}
