package ru.yandex.chemodan.app.psbilling.web.ratelimiter;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.ratelimiter.yarl.YarlHttpClient;
import ru.yandex.chemodan.ratelimiter.yarl.YarlRateLimiterHttpClientContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicProperty;

@Configuration
@Import({
        YarlRateLimiterHttpClientContextConfiguration.class,
        PsBillingCoreConfiguration.class
})
public class RateLimiterConfiguration {
    private final DynamicProperty<Boolean> yarlIsDryRun =
            new DynamicProperty<>("ps-billing-yarl.dryRun", true);

    private final DynamicProperty<Boolean> yarlIsEnabled =
            new DynamicProperty<>("ps-billing-yarl.enabled", false);

    private final DynamicProperty<Boolean> yarlIsWhiteListMode =
            new DynamicProperty<>("ps-billing-yarl.use.whitelist.mode", true);

    private final DynamicProperty<ListF<String>> yarlEnabledForClients =
            new DynamicProperty<>("ps-billing-yarl.enabled.clients", Cf.arrayList());

    private final DynamicProperty<ListF<String>> yarlDisabledForClients =
            new DynamicProperty<>("ps-billing-yarl.disabled.clients", Cf.arrayList());

    @Bean
    public PsBillingRateLimiterInterceptor psBillingRateLimiterInterceptor(YarlHttpClient yarlHttpClient) {
        return new PsBillingRateLimiterInterceptor(yarlHttpClient, yarlIsDryRun::get, yarlIsEnabled::get,
                yarlIsWhiteListMode::get, yarlEnabledForClients::get, yarlDisabledForClients::get);
    }
}
