package ru.yandex.chemodan.app.psbilling.web.services;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoPayloadEntity;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoPayloadParser;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoTemplate;
import ru.yandex.chemodan.app.psbilling.web.model.PromoPojo;

@AllArgsConstructor
public class PromoPojoService {
    private PromoPayloadDao promoPayloadDao;
    private PromoPayloadParser promoPayloadParser;

    public ListF<PromoPojo> createPromosPojo(ListF<PromoTemplate> promos, String language,
                                             Option<String> payloadType, Option<Integer> payloadVersion) {

        MapF<UUID, PromoPayloadEntity> payloads = payloadType.map(pt -> promoPayloadDao.get(
                promos.map(PromoTemplate::getId),
                pt,
                payloadVersion
        )).orElse(Cf.map());

        return promos.map(
                promo -> new PromoPojo(
                        promo.getCode(),
                        promo.getTitle(language),
                        promo.getToDate(),
                        payloads.getO(promo.getId()).map(payload -> promoPayloadParser.processPayload(payload.getContent(), language, false))
                )
        );
    }
}
