package ru.yandex.chemodan.app.psbilling.web.utils;

import java.util.regex.Pattern;

import org.springframework.core.annotation.Order;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@Order(1)
public class ExcludeByRegExpTmvFilter extends Tvm2Filter {
    private final ListF<Pattern> excludePatterns;

    public ExcludeByRegExpTmvFilter(Tvm2 tvm2,
            Tvm2CheckingMode tvm2Mode, String tvm2ServletUrlPattern,
            ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers,
            ListF<String> excludedPaths)
    {
        super(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths);
        excludePatterns = excludedPaths.map(Pattern::compile);
    }

    @Override
    protected boolean isExcluded(String path) {
        return excludePatterns.exists(p -> p.matcher(path).matches());
    }
}
