package ru.yandex.chemodan.app.psbilling.web.utils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

public class PaymentDataUtils {

    public static String buildPaymentDataId(Long personId, Long clientId, PassportUid uid) {
        return "" + uid + "_" + clientId + "_" + personId;
    }

    public static PassportUid uidFromPaymentDataId(String paymentDataId) {
        return PassportUid.cons(Long.parseLong(StringUtils.substringBefore(paymentDataId, "_")));
    }

    public static Long personIdFromPaymentDataId(String paymentDataId) {
        return Long.parseLong(StringUtils.substringAfterLast(paymentDataId, "_"));
    }

    public static Option<Long> clientIdFromPaymentDataId(String paymentDataId) {
        if (StringUtils.countMatches(paymentDataId, "_") == 2) {
            return Option.of(Long.parseLong(
                    StringUtils.substringBefore(StringUtils.substringAfter(paymentDataId, "_"), "_")));
        } else {
            //old format
            return Option.empty();
        }
    }
}
