package ru.yandex.chemodan.app.psbilling.web.validation;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.web.exceptions.AccessDeniedException;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.directory.client.DirectoryUsersInfoResponse;
import ru.yandex.inside.passport.PassportUid;


@Slf4j
@RequiredArgsConstructor
public class GroupAdminPermissionValidation {
    public static final String GROUP_ADMIN_VIEW_PERMISSION = "GROUP.ADMIN_VIEW";

    private final DirectoryClient directoryClient;
    private final FeatureFlags featureFlags;

    public void check(PassportUid uid, String groupExternalId) {
        if (!featureFlags.getHotFixGroupValidationEnabled().isEnabled()) {
            return;
        }

        boolean isAdmin = directoryClient.getUserInfo(uid, groupExternalId)
                .map(DirectoryUsersInfoResponse::isAdmin)
                .orElse(false);

        if (!isAdmin) {
            log.error("User {} in groupExternalId {} is not an admin", uid, groupExternalId);
            throw new AccessDeniedException(GROUP_ADMIN_VIEW_PERMISSION);
        }
    }
}
