package ru.yandex.chemodan.app.psbilling.web.validation;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.HttpStatus;


@Slf4j
@RequiredArgsConstructor
public class GroupValidator {
    private final GroupsManager groupsManager;

    public void checkOrganizationIsNotPartnerClient(PassportUid uid, String groupExternalId) {
        Option<Group> group = groupsManager.findGroup(uid,
                GroupType.ORGANIZATION, groupExternalId);
        if (group.isPresent()) {
            checkIsNotPartnerClient(group.get());
        }
    }

    public void checkIsNotPartnerClient(@NotNull Group group) {
        if (groupsManager.isPartnerClient(group.getId())) {
            log.error("Can't continue: group {} is partner client", group.getExternalId());
            throw new A3ExceptionWithStatus("partner_client",
                    "Group is partner client", HttpStatus.SC_400_BAD_REQUEST);
        }
    }
}
