package ru.yandex.chemodan.app.psbilling.worker.actualization.userservice;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationService;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@RequiredArgsConstructor
public class UserServicesActualizeCroneTask extends CronTask {
    private final UserServiceActualizationService userServiceActualizationService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("* * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        userServiceActualizationService.scheduleUserServicesActualization();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
