package ru.yandex.chemodan.app.psbilling.worker.actualization.userservicefeature;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature.UserFeaturesActualizationService;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@RequiredArgsConstructor
public class UserServiceFeaturesActualizeCroneTask extends CronTask {
    private final UserFeaturesActualizationService userFeaturesActualizationService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("* * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        userFeaturesActualizationService.scheduleFeatureSynchronization();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
