package ru.yandex.chemodan.app.psbilling.worker.billing.cards;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class CheckCardBindingCrone extends CronTask {
    private CardBindingChecker cardBindingChecker;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("* * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        cardBindingChecker.scheduleToCheckInitBindings();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
