package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.mail.EventMailType;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.MoscowTime;
import ru.yandex.misc.time.TimeUtils;

public class CheckGroupServiceTrialEndedCrone extends CronTask {

    private final GroupServicesManager groupServicesManager;

    public CheckGroupServiceTrialEndedCrone(GroupServicesManager groupServicesManager) {
        this.groupServicesManager = groupServicesManager;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        LocalDate today = LocalDate.now(MoscowTime.TZ);
        groupServicesManager.scheduleEmailForGroupServicesWithEndedTrialInADayMsk(
                today.minusDays(1),
                EventMailType.B2B_JUST_PAID_OR_END_TRIAL);
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 3 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
