package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

public class CheckOldInitGroupPaymentsCrone extends CronTask {

    private final GroupBillingService groupBillingService;

    public CheckOldInitGroupPaymentsCrone(GroupBillingService groupBillingService) {
        this.groupBillingService = groupBillingService;
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("*/15 * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        groupBillingService.scheduleToCheckOldInitPaymentRequests();
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
