package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.DistributionPlatformCalculationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

public class DistributionPlatformCalculationCrone extends CronTask {
    private DistributionPlatformCalculationService distributionPlatformCalculationService;

    public DistributionPlatformCalculationCrone(DistributionPlatformCalculationService distributionPlatformCalculationService) {
        this.distributionPlatformCalculationService = distributionPlatformCalculationService;
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("5 */2 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        distributionPlatformCalculationService.scheduleDistributionPlatformCalculation();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}

