package ru.yandex.chemodan.app.psbilling.worker.billing.groups;


import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class GroupsBillingCalculationCrone extends CronTask {
    private GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("5 * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        groupServiceTransactionsCalculationService.scheduleNotCalculated();
    }


    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}
