package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.distributionplatform.DistributionPlatformTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class RemoveOldExportsCrone extends CronTask {
    private GroupServiceTransactionsExportService groupServiceTransactionsExportService;
    private DistributionPlatformTransactionsExportService distributionPlatformTransactionsExportService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 20 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        groupServiceTransactionsExportService.removeOldExports();
        distributionPlatformTransactionsExportService.removeOldExports();
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}
