package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.MoscowTime;

public class SendB2bBalanceExhaustedLatelyEmailsCrone extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(SendB2bBalanceExhaustedLatelyEmailsCrone.class);

    private final DynamicProperty<Integer> exhaustedBalanceEmailHours =
            new DynamicProperty<>("ps-billing-exhausted-balance-lately-email-hours", 7 * 24);

    private final GroupServicesManager groupServicesManager;
    private final FeatureFlags featureFlags;

    public SendB2bBalanceExhaustedLatelyEmailsCrone(GroupServicesManager groupServicesManager,
                                                    FeatureFlags featureFlags) {
        this.groupServicesManager = groupServicesManager;
        this.featureFlags = featureFlags;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (!featureFlags.getB2bBalanceExhaustedLatelyEmailEnabled().isEnabled()) {
            logger.info("Sending b2b balance exhausted lately emails is disabled");
            return;
        }
        Instant intervalStart = Instant.now().minus(Duration.standardHours(exhaustedBalanceEmailHours.get()));
        String emailKey = "b2b_balance_exhausted_lately_email";
        groupServicesManager.scheduleB2bBalanceExhaustedLatelyEmails(emailKey, intervalStart);
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("23 * * * *", MoscowTime.TZ);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
