package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.mail.Utils;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.MoscowTime;

import static ru.yandex.chemodan.app.psbilling.core.mail.Utils.toDuration;

public class SendB2bUpsaleEmailsCrone extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(SendB2bUpsaleEmailsCrone.class);

    private final DynamicProperty<String> b2bUpsaleEmailDelay = new DynamicProperty<>(
            "ps-billing-b2b-upsale-email-delay", CustomPeriod.fromHours(60 * 24).toString(),
            Utils::validateCustomPeriod);

    private final GroupServicesManager groupServicesManager;
    private final FeatureFlags featureFlags;

    public SendB2bUpsaleEmailsCrone(GroupServicesManager groupServicesManager, FeatureFlags featureFlags) {
        this.groupServicesManager = groupServicesManager;
        this.featureFlags = featureFlags;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (!featureFlags.getB2bUpsaleEmailEnabled().isEnabled()) {
            logger.info("Sending b2b upsale emails is disabled");
            return;
        }
        groupServicesManager.sendB2bUpsaleEmails(Instant.now().minus(toDuration(b2bUpsaleEmailDelay)));
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("43 * * * *", MoscowTime.TZ);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(2);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
