package ru.yandex.chemodan.app.psbilling.worker.billing.groups;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.MoscowTime;

public class SendPaymentReminderEmailsCrone extends CronTask {

    private final GroupServicesManager groupServicesManager;

    public SendPaymentReminderEmailsCrone(GroupServicesManager groupServicesManager) {
        this.groupServicesManager = groupServicesManager;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        groupServicesManager.sendPaymentReminderEmails(LocalDate.now(MoscowTime.TZ));
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 3 * * *", MoscowTime.TZ);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}
