package ru.yandex.chemodan.app.psbilling.worker.billing.users;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.users.TrustRefundService;
import ru.yandex.chemodan.app.psbilling.core.dao.users.RefundDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class CheckRefundsCrone extends CronTask {
    private final TrustRefundService trustRefundService;
    private final RefundDao refundDao;
    private static final int BATCH_SIZE = 2000;


    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("*/5 * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Option<UUID> from = Option.empty();
        int selected = BATCH_SIZE;
        while (selected == BATCH_SIZE) {
            ListF<UUID> orderIds = refundDao.findInInitStatus(from, BATCH_SIZE);
            orderIds.forEach(trustRefundService::scheduleCheckRefund);

            selected = orderIds.size();
            from = orderIds.lastO();
        }
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}
