package ru.yandex.chemodan.app.psbilling.worker.billing.users;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.OrderProcessorFacade;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceEntity;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class CheckUserServiceCrone extends CronTask {
    private static final int BATCH_SIZE = 2000;
    private final UserServiceDao userServiceDao;
    private final OrderProcessorFacade orderProcessorFacade;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("* * * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Option<UUID> from = Option.empty();
        int selected = BATCH_SIZE;
        while (selected == BATCH_SIZE) {
            ListF<UserServiceEntity> services = userServiceDao.findUserServicesForCheck(from, BATCH_SIZE);
            services.forEach(orderProcessorFacade::scheduleCheckService);

            selected = services.size();
            from = services.lastO().map(UserServiceEntity::getId);
        }
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
