package ru.yandex.chemodan.app.psbilling.worker.billing.users;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.billing.users.ProductsExportService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class ExportProductsToTrustCrone extends CronTask {
    private final ProductsExportService productsExportService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 1 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        productsExportService.exportProducts();
    }


    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }

}
