package ru.yandex.chemodan.app.psbilling.worker.billing.users;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.admin.InappMigrationService;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class InappMigrationsCrone extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(InappMigrationsCrone.class);

    private final InappMigrationService inappMigrationService;
    private final FeatureFlags featureFlags;


    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 13 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (featureFlags.getInappMigrationAllowed().isEnabled())
            inappMigrationService.loadMigrationCandidates(false);
        else
            logger.info("Inapp migration disabled");
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
