package ru.yandex.chemodan.app.psbilling.worker.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember.GroupServiceMemberActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservicefeature.GroupFeaturesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature.UserFeaturesActualizationService;
import ru.yandex.chemodan.app.psbilling.worker.actualization.groupmember.GroupServiceMembersActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.groupmember.GroupServiceMembersSyncStateActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.groupservice.GroupServicesSyncStateActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.groupservice.GroupsActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.groupservicefeature.GroupServiceFeaturesActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.userservice.UserServicesActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.userservice.UserServicesSyncStateActualizeCroneTask;
import ru.yandex.chemodan.app.psbilling.worker.actualization.userservicefeature.UserServiceFeaturesActualizeCroneTask;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class ActualizationWorkerConfiguration {
    @Bean
    public GroupsActualizeCroneTask groupsActualizeCroneTask(
            GroupServicesActualizationService groupServicesActualizationService) {
        return new GroupsActualizeCroneTask(groupServicesActualizationService);
    }

    @Bean
    public GroupServicesSyncStateActualizeCroneTask groupServicesSyncStateActualizeCroneTask(
            GroupServicesActualizationService groupServicesActualizationService) {
        return new GroupServicesSyncStateActualizeCroneTask(groupServicesActualizationService);
    }

    @Bean
    public GroupServiceMembersActualizeCroneTask groupServiceMembersActualizeCroneTask(
            GroupServiceMemberActualizationService groupServiceMemberActualizationService) {
        return new GroupServiceMembersActualizeCroneTask(groupServiceMemberActualizationService);
    }

    @Bean
    public GroupServiceMembersSyncStateActualizeCroneTask groupServiceMembersSyncStateActualizeCroneTask(
            GroupServiceMemberActualizationService groupServiceMemberActualizationService) {
        return new GroupServiceMembersSyncStateActualizeCroneTask(groupServiceMemberActualizationService);
    }

    @Bean
    public UserServicesActualizeCroneTask userServicesActualizeCroneTask(
            UserServiceActualizationService userServiceActualizationService) {
        return new UserServicesActualizeCroneTask(userServiceActualizationService);
    }

    @Bean
    public UserServicesSyncStateActualizeCroneTask userServicesSyncStateActualizeCroneTask(
            UserServiceActualizationService userServiceActualizationService) {
        return new UserServicesSyncStateActualizeCroneTask(userServiceActualizationService);
    }

    @Bean
    public UserServiceFeaturesActualizeCroneTask groupServiceFeaturesActualizeCroneTask(
            UserFeaturesActualizationService userFeaturesActualizationService) {
        return new UserServiceFeaturesActualizeCroneTask(userFeaturesActualizationService);
    }

    @Bean
    public GroupServiceFeaturesActualizeCroneTask userServiceFeaturesActualizeCroneTask(
            GroupFeaturesActualizationService groupFeaturesActualizationService) {
        return new GroupServiceFeaturesActualizeCroneTask(groupFeaturesActualizationService);
    }
}
