package ru.yandex.chemodan.app.psbilling.worker.config;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoResurrectionPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.DistributionPlatformCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.distributionplatform.DistributionPlatformTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.worker.billing.cards.CheckCardBindingCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.CheckGroupServiceTrialEndedCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.CheckGroupServiceTrialWillEndSoonCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.CheckGroupsBillingStatusCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.CheckOldInitGroupPaymentsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.DistributionPlatformCalculationCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.DistributionPlatformExportCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.GroupAutoBillingCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.GroupAutoReBillingCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.GroupsBillingCalculationCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.GroupsBillingExportCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.RemoveOldExportsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.SendB2bBalanceExhaustedLatelyEmailsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.SendB2bUpsaleEmailsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.SendPaymentReminderEmailsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.groups.UpdateClientBalanceCrone;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class GroupBillingWorkerConfiguration {
    @Bean
    public DistributionPlatformCalculationCrone distributionPlatformCalculationCrone(
            DistributionPlatformCalculationService distributionPlatformCalculationService) {
        return new DistributionPlatformCalculationCrone(distributionPlatformCalculationService);
    }

    @Bean
    public DistributionPlatformExportCrone distributionPlatformExportCrone(
            DistributionPlatformTransactionsExportService distributionPlatformTransactionsExportService) {
        return new DistributionPlatformExportCrone(distributionPlatformTransactionsExportService);
    }

    @Bean
    public GroupsBillingCalculationCrone groupsBillingCalculationCrone(
            GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService) {
        return new GroupsBillingCalculationCrone(groupServiceTransactionsCalculationService);
    }

    @Bean
    public GroupsBillingExportCrone groupsBillingExportCrone(
            GroupServiceTransactionsExportService groupServiceTransactionsExportService) {
        return new GroupsBillingExportCrone(groupServiceTransactionsExportService);
    }

    @Bean
    public CheckGroupsBillingStatusCrone checkGroupsBillingStatusCrone(GroupBillingService groupBillingService) {
        return new CheckGroupsBillingStatusCrone(groupBillingService);
    }

    @Bean
    public RemoveOldExportsCrone removeOldExportsCrone(
            GroupServiceTransactionsExportService groupServiceTransactionsExportService,
            DistributionPlatformTransactionsExportService distributionPlatformTransactionsExportService
    ) {
        return new RemoveOldExportsCrone(groupServiceTransactionsExportService, distributionPlatformTransactionsExportService);
    }

    @Bean
    public CheckGroupServiceTrialEndedCrone checkGroupServiceTrialEndedCrone(GroupServicesManager groupServicesManager) {
        return new CheckGroupServiceTrialEndedCrone(groupServicesManager);
    }

    @Bean
    public CheckGroupServiceTrialWillEndSoonCrone checkGroupServiceTrialWillEndSoonCrone(GroupServicesManager groupServicesManager) {
        return new CheckGroupServiceTrialWillEndSoonCrone(groupServicesManager);
    }

    @Bean
    public CheckOldInitGroupPaymentsCrone checkOldInitGroupPaymentsCrone(GroupBillingService groupBillingService) {
        return new CheckOldInitGroupPaymentsCrone(groupBillingService);
    }

    @Bean
    public UpdateClientBalanceCrone updateClientBalanceCrone(ClientBalanceCalculator clientBalanceCalculator) {
        return new UpdateClientBalanceCrone(clientBalanceCalculator);
    }

    @Bean
    public GroupAutoBillingCrone groupAutoBillingCrone(AutoPayManager autoPayManager) {
        return new GroupAutoBillingCrone(autoPayManager);
    }

    @Bean
    public GroupAutoReBillingCrone groupAutoReBillingCrone(AutoResurrectionPayManager autoResurrectionPayManager) {
        return new GroupAutoReBillingCrone(autoResurrectionPayManager);
    }

    @Bean
    public SendPaymentReminderEmailsCrone sendPaymentReminderEmailsCrone(GroupServicesManager groupServicesManager) {
        return new SendPaymentReminderEmailsCrone(groupServicesManager);
    }

    @Bean
    public SendB2bBalanceExhaustedLatelyEmailsCrone sendB2bBalanceExhaustedLatelyEmailsCrone(GroupServicesManager groupServicesManager,
                                                                                             FeatureFlags featureFlags) {
        return new SendB2bBalanceExhaustedLatelyEmailsCrone(groupServicesManager, featureFlags);
    }

    @Bean
    public SendB2bUpsaleEmailsCrone sendB2bUpsaleEmailsCrone(GroupServicesManager groupServicesManager,
                                                             FeatureFlags featureFlags) {
        return new SendB2bUpsaleEmailsCrone(groupServicesManager, featureFlags);
    }

    @Bean
    public CheckCardBindingCrone CheckCardBindingCrone(CardBindingChecker cardBindingChecker) {
        return new CheckCardBindingCrone(cardBindingChecker);
    }
}
