package ru.yandex.chemodan.app.psbilling.worker.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.distributionplatform.DistributionPlatformTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.Settings;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.TrustCardBindingDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.GroupServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceMemberDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.billing.ClientBalanceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserPassportSyncService;
import ru.yandex.chemodan.app.psbilling.worker.monitor.BalanceStatusMonitor;
import ru.yandex.chemodan.app.psbilling.worker.monitor.PsBillingStaleRecordsMonitor;
import ru.yandex.chemodan.app.psbilling.worker.monitor.YtJobsStatusMonitor;
import ru.yandex.chemodan.app.psbilling.worker.texts.TankerTextsUpdateCrone;
import ru.yandex.chemodan.app.psbilling.worker.user.UserPassportSyncCrone;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class PsBillingWorkerCoreConfiguration {
    @Bean
    public PsBillingStaleRecordsMonitor psBillingStaleRecordsMonitor(
            OrderDao orderDao, UserServiceFeatureDao userServiceFeatureDao,
            GroupServiceFeatureDao groupServiceFeatureDao, TrustCardBindingDao trustCardBindingDao,
            UserServiceDao userServiceDao, GroupServiceMemberDao groupServiceMemberDao,
            GroupServiceDao groupServiceDao, ClientBalanceDao clientBalanceDao, Settings settings) {
        return new PsBillingStaleRecordsMonitor(userServiceFeatureDao, groupServiceFeatureDao, userServiceDao,
                groupServiceMemberDao, groupServiceDao, orderDao, clientBalanceDao, trustCardBindingDao, settings);
    }

    @Bean
    public YtJobsStatusMonitor ytJobsStatusMonitor(
            DistributionPlatformTransactionsExportService dpExportService,
            GroupServiceTransactionsExportService gsExportService) {
        return new YtJobsStatusMonitor(dpExportService, gsExportService);
    }

    @Bean
    public BalanceStatusMonitor balanceStatusMonitor(
            ClientBalanceDao clientBalanceDao, GroupDao groupDao, GroupServiceDao groupServiceDao,
            GroupTrustPaymentRequestDao groupTrustPaymentRequestDao) {
        return new BalanceStatusMonitor(clientBalanceDao, groupDao, groupServiceDao, groupTrustPaymentRequestDao);
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${ps-billing.synchronize_organizations.tasks.limit}") int syncOrgThreadsCount,
            @Value("${ps-billing.synchronize_organizations.tasks.queue.size.coeff}") int syncOrgTasksQueueCoeff,
            @Value("${ps-billing.synchronize_features.tasks.limit}") int syncFeaturesThreadsCount,
            @Value("${ps-billing.synchronize_features.tasks.queue.size.coeff}") int syncFeaturesTasksQueueCoeff,
            @Value("${ps-billing.check_trust_payments.tasks.limit}") int checkTrustPaymentsThreadsCount,
            @Value("${ps-billing.check_trust_payments.tasks.queue.size.coeff}") int checkTrustPaymentsQueueCoeff,
            @Value("${ps-billing.send_transactional_emails_with_invoices.tasks.limit}") int emailsWithInvoicesThreadsCount,
            @Value("${ps-billing.send_transactional_emails_with_invoices.tasks.queue.size.coeff}") int emailsWithInvoicesTasksQueueCoeff,
            @Value("${ps-billing.inapp_migrations.tasks.limit}") int inappMigrationThreadsCount,
            @Value("${ps-billing.inapp_migrations.tasks.queue.size.coeff}") int inappMigrationTasksQueueCoeff,
            @Value("${ps-billing.auto_charge.tasks.limit}") int autoChargePaymentsThreadsCount,
            @Value("${ps-billing.auto_charge.tasks.queue.size.coeff}") int autoChargePaymentsTasksQueueCoeff
    ) {
        TaskQueue synchronizeOrganization = new TaskQueue(PsBillingQueueNames.SYNCHRONIZE_ORGANIZATION,
                syncOrgThreadsCount, syncOrgTasksQueueCoeff * syncOrgThreadsCount
        );
        TaskQueue synchronizeFeatures = new TaskQueue(PsBillingQueueNames.SYNCHRONIZE_FEATURES,
                syncFeaturesThreadsCount, syncFeaturesThreadsCount * syncFeaturesTasksQueueCoeff
        );

        TaskQueue checkUserOrders = new TaskQueue(PsBillingQueueNames.CHECK_TRUST_PAYMENTS,
                checkTrustPaymentsThreadsCount, checkTrustPaymentsThreadsCount * checkTrustPaymentsQueueCoeff);

        TaskQueue sendTransactionalEmailsWithInvoices =
                new TaskQueue(PsBillingQueueNames.SEND_TRANSACTIONAL_EMAILS_WITH_INVOICES,
                        emailsWithInvoicesThreadsCount,
                        emailsWithInvoicesThreadsCount * emailsWithInvoicesTasksQueueCoeff);

        TaskQueue inappMigration =
                new TaskQueue(PsBillingQueueNames.MIGRATE_INAPP_SUBSCRIPTION,
                        inappMigrationThreadsCount,
                        inappMigrationThreadsCount * inappMigrationTasksQueueCoeff);

        TaskQueue autoChargePayments =
                new TaskQueue(PsBillingQueueNames.AUTO_CHARGE_PAYMENTS,
                        autoChargePaymentsThreadsCount,
                        autoChargePaymentsThreadsCount * autoChargePaymentsTasksQueueCoeff);

        return new BazingaWorkerTaskQueues(
                PsBillingQueueNames.CRON, PsBillingQueueNames.REGULAR, PsBillingQueueNames.CPU_INTENSIVE,
                Cf.list(synchronizeOrganization, synchronizeFeatures, checkUserOrders,
                        sendTransactionalEmailsWithInvoices, inappMigration, autoChargePayments));
    }

    @Bean
    public TankerTextsUpdateCrone tankerTextsUpdateCrone(TextsManager textsManager) {
        return new TankerTextsUpdateCrone(textsManager);
    }

    @Bean
    public UserPassportSyncCrone userPassportSyncCrone(UserPassportSyncService userPassportSyncService) {
        return new UserPassportSyncCrone(userPassportSyncService);
    }
}
