package ru.yandex.chemodan.app.psbilling.worker.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.admin.InappMigrationService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.ProductsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.TrustRefundService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.OrderProcessorFacade;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.Settings;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.RefundDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.CheckOrdersCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.CheckOrdersInHoldCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.CheckRefundsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.CheckUserServiceCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.ExportProductsToTrustCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.InappMigrationsCrone;
import ru.yandex.chemodan.app.psbilling.worker.billing.users.InappUserServiceSynchronizationCrone;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class UserBillingWorkerConfiguration {

    @Bean
    public ExportProductsToTrustCrone exportProductsToTrustCrone(ProductsExportService productsExportService) {
        return new ExportProductsToTrustCrone(productsExportService);
    }

    @Bean
    public CheckOrdersCrone checkOrdersCrone(OrderProcessorFacade orderProcessorFacade, OrderDao orderDao) {
        return new CheckOrdersCrone(orderProcessorFacade, orderDao);
    }

    @Bean
    public InappMigrationsCrone inappMigrationsCrone(InappMigrationService inappMigrationService,
                                                     FeatureFlags featureFlags) {
        return new InappMigrationsCrone(inappMigrationService, featureFlags);
    }

    @Bean
    public CheckRefundsCrone checkRefundsCrone(TrustRefundService trustRefundService, RefundDao refundDao) {
        return new CheckRefundsCrone(trustRefundService, refundDao);
    }

    @Bean
    public CheckUserServiceCrone checkUserServiceCrone(OrderProcessorFacade orderProcessorFacade,
                                                       UserServiceDao userServiceDao) {
        return new CheckUserServiceCrone(userServiceDao, orderProcessorFacade);
    }

    @Bean
    public InappUserServiceSynchronizationCrone forceCheckInappUserServicesCrone(OrderProcessorFacade orderProcessorFacade,
                                                                                 UserServiceDao userServiceDao, Settings settings) {
        return new InappUserServiceSynchronizationCrone(userServiceDao, orderProcessorFacade, settings);
    }

    @Bean
    public CheckOrdersInHoldCrone checkOrdersInHoldCrone(OrderDao orderDao, OrderProcessorFacade orderProcessorFacade){
        return new CheckOrdersInHoldCrone(orderDao, orderProcessorFacade);
    }
}
