package ru.yandex.chemodan.app.psbilling.worker.monitor;

import java.lang.invoke.MethodHandles;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import lombok.RequiredArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.worker.DelayingWorkerThread;
import ru.yandex.misc.worker.Workers;

@RequiredArgsConstructor
// https://wiki.yandex-team.ru/disk/java/faq/#vkljuchenieunistatqloud
// yasmMetricsRegistry.addPattern(".*ps-billing.*")
public abstract class AbstractMonitor implements MonicaContainer {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Duration TASK_DELAY = Duration.standardMinutes(3);

    private volatile DelayingWorkerThread workerThread;
    private final String name;
    private final String description;


    public abstract void updateState();

    public abstract void resetState();

    @PostConstruct
    public void startWorker() {
        workerThread = Workers.newDelayingWorker(this::updateState,
                getClass().getSimpleName(), TASK_DELAY, Workers.SleepMode.PERIOD, false);
        workerThread.startGracefully();
    }

    @PreDestroy
    public void stopWorker() {
        if (workerThread == null) {
            // just in case, should never happen
            logger.error("No worker thread");
            return;
        }
        workerThread.stopGracefully();
        workerThread = null;
        resetState();
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(name, new MetricName("ps-billing", name), description);
    }
}
