package ru.yandex.chemodan.app.psbilling.worker.user;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.users.UserPassportSyncService;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.time.TimeUtils;

@AllArgsConstructor
public class UserPassportSyncCrone extends CronTask {
    private final UserPassportSyncService userPassportSyncService;

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 5 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        if (EnvironmentType.getActive() == EnvironmentType.PRODUCTION || EnvironmentType.getActive() == EnvironmentType.PRESTABLE) {
            userPassportSyncService.syncDeletedInPassportUsers();
        }
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CRON;
    }
}
