package ru.yandex.chemodan.qa.psbilling.util

private val RANDOM = kotlin.random.Random

/**
 * ОГРН (основной государственный регистрационный номер) состоит из 13 цифр:
 *
 *
 * 1-я цифра — признак отнесения государственного регистрационного номера записи:
 * к основному государственному регистрационному номеру (ОГРН) — 1, 5;
 * к основному государственному регистрационному номеру индивидуального предпринимателя (ОГРНИП) — 3;
 * к государственному регистрационному номеру — 2, 6, 7, 8, 9 (для ЕГРЮЛ), 4 (для ЕГРИП);
 * 2-3-я цифры — две последние цифры года внесения записи;
 * 4-5-я цифры — код субъекта Российской Федерации;
 * 6-12-я цифры — номер записи, внесенной в государственный реестр в течение года;
 * 13-я цифра — контрольное число.
 * Маски ввода
 * XXXXXXXXXXXXX — маска ввода без разделителей.
 * X-XX-XX-XXXXXXX-X — маска ввода с разделителями.
 *
 * @return
 */
fun randomOgrn(): String {
    var result = ""
    result += RANDOM.nextInt(9) + 1
    for (i in 11 downTo 1) {
        result += RANDOM.nextInt(10)
    }
    val n13 = (result.toLong() % 11 % 10).toInt()
    result += n13
    return result
}

/**
 * ИНН (идентификационный номер налогоплательщика) физического лица из 12 цифр:
 *
 *
 * 1-4-я цифры:
 * для российской организации — код налогового органа, который присвоил ИНН;
 * для иностранной организации — индекс, определяемый Федеральной налоговой службой;
 * 5-9-я цифры:
 * для российской организации — порядковый номер записи о лице в территориальном разделе Единого государственного реестра налогоплательщиков налогового органа, который присвоил ИНН;
 * для иностранной организации — код иностранной организации (КИО) согласно Справочнику «Коды иностранных организаций»;
 * 10-я цифра — контрольное число.
 * ИНН физического лица (индивидуального предпринимателя) состоит из 12 цифр:
 *
 *
 * 1-4-я цифры — код налогового органа, который присвоил ИНН;
 * 5-10-я цифры — порядковый номер записи о лице в территориальном разделе Единого государственного реестра налогоплательщиков налогового органа, который присвоил ИНН;
 * 11-12-я цифры — контрольное число.
 *
 *
 * Алгоритм проверки контрольного числа
 * 12-значный ИНН
 * Вычислить 1-ю контрольную цифру:
 * Вычислить сумму произведений цифр ИНН (с 1-й по 10-ю) на следующие коэффициенты — 7, 2, 4, 10, 3, 5, 9, 4, 6, 8 (т.е. 7 * ИНН[1] + 2 * ИНН[2] + ...).
 * Вычислить младший разряд остатка от деления полученной суммы на 11.
 * Вычислить 2-ю контрольную цифру:
 * Вычислить сумму произведений цифр ИНН (с 1-й по 11-ю) на следующие коэффициенты — 3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8 (т.е. 3 * ИНН[1] + 7 * ИНН[2] + ...).
 * Вычислить младший разряд остатка от деления полученной суммы на 11.
 * Сравнить 1-ю контрольную цифру с 11-й цифрой ИНН и сравнить 2-ю контрольную цифру с 12-й цифрой ИНН. Если они равны, то ИНН верный.
 *
 * @return
 */
fun randomINNFiz(): String {
    var result = ""
    var r: Int = RANDOM.nextInt(10)
    var s1 = r * 7
    var s2 = r * 3
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 2
    s2 += r * 7
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 4
    s2 += r * 2
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 10
    s2 += r * 4
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 3
    s2 += r * 10
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 5
    s2 += r * 3
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 9
    s2 += r * 5
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 4
    s2 += r * 9
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 6
    s2 += r * 4
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 8
    s2 += r * 6
    result += r
    r = s1 % 11 % 10
    s2 += r * 8
    result += r
    r = s2 % 11 % 10
    result += r
    return result
}

/**
 * ИНН (идентификационный номер налогоплательщика) организации состоит из 10 цифр:
 *
 *
 * 1-4-я цифры:
 * для российской организации — код налогового органа, который присвоил ИНН;
 * для иностранной организации — индекс, определяемый Федеральной налоговой службой;
 * 5-9-я цифры:
 * для российской организации — порядковый номер записи о лице в территориальном разделе Единого государственного реестра налогоплательщиков налогового органа, который присвоил ИНН;
 * для иностранной организации — код иностранной организации (КИО) согласно Справочнику «Коды иностранных организаций»;
 * 10-я цифра — контрольное число.
 *
 *
 * Алгоритм проверки контрольного числа
 * 10-значный ИНН
 * Вычислить сумму произведений цифр ИНН (с 1-й по 9-ю) на следующие коэффициенты — 2, 4, 10, 3, 5, 9, 4, 6, 8 (т.е. 2 * ИНН[1] + 4 * ИНН[2] + ...).
 * Вычислить остаток от деления полученной суммы на 11.
 * Сравнить младший разряд полученного остатка от деления с младшим разрядом ИНН. Если они равны, то ИНН верный.
 *
 * @return
 */
fun randomINNOrg(): String {
    var result = ""
    var r: Int = RANDOM.nextInt(10)
    var s1 = r * 2
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 4
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 10
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 3
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 5
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 9
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 4
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 6
    result += r
    r = RANDOM.nextInt(10)
    s1 += r * 8
    result += r
    r = s1 % 11 % 10
    result += r
    return result
}

/**
 * КПП (код причины постановки на учет) состоит из 9 знаков:
 *
 *
 * 1-4-я цифры — код налогового органа, который осуществил постановку на учет организации или осуществил учет сведений в отношении организации;
 * 5-6-й знаки — причина постановки на учет (учета сведений), представляют собой цифры или заглавные буквы латинского алфавита от A до Z. Числовое значение двух знаков может принимать значение:
 * для российской организации — от 01 до 50 (01 — по месту ее нахождения);
 * для иностранной организации — от 51 до 99;
 * 7-9-я цифры — порядковый номер постановки на учет (учета сведений) в налоговом органе по соответствующему основанию.
 *
 * @return КПП
 */
fun randomKPP(): String {

    var result = ""
    for (i in 9 downTo 1) {
        result += RANDOM.nextInt(10)
    }
    return result
}

