OWNER(g:disk)

JUNIT5()

SIZE(LARGE)
TAG(ya:manual)

WITH_KOTLIN()

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/5.8.2/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/fasterxml/jackson/jackson-bom/2.13.2/ya.dependency_management.inc)

SET(ASPECTJ_VERSION 1.9.7)

PEERDIR(
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin
    contrib/java/com/fasterxml/jackson/core/jackson-core
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310

    contrib/java/org/junit/jupiter/junit-jupiter-api
    contrib/java/org/junit/jupiter/junit-jupiter-engine
    contrib/java/org/junit/jupiter/junit-jupiter-params

    contrib/java/org/aspectj/aspectjweaver/${ASPECTJ_VERSION}
    contrib/java/org/assertj/assertj-core/3.22.0

    contrib/java/io/rest-assured/rest-assured/4.4.0
    contrib/java/io/rest-assured/kotlin-extensions/4.4.0

    contrib/java/io/qameta/allure/allure-rest-assured/2.12.1
    contrib/java/io/qameta/allure/allure-junit5/2.12.1

    contrib/java/org/awaitility/awaitility/4.1.1
    contrib/java/org/awaitility/awaitility-kotlin/4.1.1

    contrib/java/org/hamcrest/hamcrest-all/1.3

    # Круто бы завезти https://github.com/sksamuel/hoplite Более универсальный
    contrib/java/ru/yandex/qatools/secrets-loader/1.1
    contrib/java/ru/yandex/qatools/properties/properties-loader/1.5
)

EXCLUDE(
    #from rest-assured/kotlin-extensions
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib-jdk8/1.5.0
    #from awaitility/awaitility-kotlin
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib/1.5.0
)

JVM_ARGS(
    -Dallure.results.directory=allure
    -javaagent:${ARCADIA_BUILD_ROOT}/contrib/java/org/aspectj/aspectjweaver/${ASPECTJ_VERSION}/aspectjweaver-${ASPECTJ_VERSION}.jar
)

JAVA_SRCS(SRCDIR kotlin **/*)
JAVA_SRCS(SRCDIR resources **/*)

LINT(base)
END()
